<?php
/**
 * Mu Roulette
 * https://webenginecms.org/
 * 
 * @version 1.0.0
 * @author Lautaro Angelico <http://lautaroangelico.com/>
 * @copyright (c) 2013-2019 Lautaro Angelico, All Rights Reserved
 * @build w3c8c718b75a0f1fa1a557f7f9d70877
 */

// namespace
namespace Plugin\MuRoulette;

// plugin root
define('__PATH_ROULETTE_ROOT__', __PATH_PLUGINS__.'roulette/');

// plugin home url
define('__ROULETTE_HOME__', __BASE_URL__.'roulette/');

// admincp
$extra_admincp_sidebar[] = array(
    'Mu Roulette', array(
        array('Settings','roulette&page=settings'),
        array('Full Logs','roulette&page=logs'),
        array('Unused Tickets','roulette&page=unused'),
        array('Account Logs','roulette&page=userlogs'),
    )
);

// language phrases
if(file_exists(__PATH_ROULETTE_ROOT__ . 'languages/'.config('language_default', true).'/language.php')) {
	// attempt to load same language as website
	if(!@include_once(__PATH_ROULETTE_ROOT__ . 'languages/'.config('language_default', true).'/language.php')) throw new Exception('Error loading language file (roulette).');
} else {
	// load default language file (en)
	if(!@include_once(__PATH_ROULETTE_ROOT__ . 'languages/en/language.php')) throw new Exception('Error loading language file (roulette).');
}

// load classes
if(!@include_once(__PATH_ROULETTE_ROOT__ . 'classes/class.roulette.php')) throw new Exception(lang('roulette_error_1'));